﻿using System;
using AntiXssEnc = Microsoft.Security.Application;

namespace VIRP_WEB.BaseCode
{
    public static class Helpers
    {
        public static Boolean IsInteger(string valueToCheck)
        {
            long tempInt;

            try
            {
                tempInt = Convert.ToInt64(valueToCheck);
                return true;
            }
            catch
            {
                return false;
            }
        }

        public static Boolean IsString(string valueToCheck)
        {
            string tempString;

            try
            {
                tempString = valueToCheck.ToString();
                return true;
            }
            catch
            {
                return false;
            }
        }

        public static string AntiXssEval(Object o)
        {
            if (o == null)
            {
                return string.Empty;
            }
            return AntiXssEnc.Encoder.HtmlEncode(o.ToString(), false);
        }
        
        public static bool IsSessionVariableNullOrEmpty(object sessionVariable)
        {
            return string.IsNullOrEmpty(GetStringFromSessionVariable(sessionVariable));
        }

        public static int GetIntFromString(string inString)
        {
            int returnInt = 0;

            int tempInt;
            bool result = int.TryParse(inString, out tempInt);
            if (result)
            {
                returnInt = tempInt;
            }

            return returnInt;
        }

        public static string GetStringFromSessionVariable(object sessionVariable)
        {
            string result = string.Empty;

            if (sessionVariable != null)
            {
                result = sessionVariable.ToString();
            }

            return result;
        }
    }
}